# Gitana Driver for Cloud CMS

This driver provides connectivity between a JavaScript application and Cloud CMS.

The JavaScript application can be running within the browser or on the server.  The Gitana Driver supports both
global namespace (conventional) JavaScript applications as well as CommonJS/AMD containers such as NodeJS.

## In the Web Browser

To use this driver within your browser application, you first download the driver and then pull into your page
like so:

```bash
<script type="text/javascript" src="gitana.min.js"></script>
```

And then you connect to Cloud CMS by identifying your client key/secret and authentication username and password.

```bash
Gitana.connect({
    "clientKey": "<clientKey>",
    "clientSecret": "<clientSecret>"
    "username": "<username>",
    "password": "<password>"
}, function(err) {

    // this = platform

});
```

Where <b>clientKey</b> and <b>clientSecret</b> are used to identify your client application.  You can use the
client key/secret combination generated by default for your platform or you can create a new client.  Ideally, you
will have one client per JS/HTML5 or Node.js application running out in the wild.

You can provide the <b>username</b> and <b>password</b> for any valid user on your platform.  Make sure that this user
has sufficient CONNECT privileges to the platform and that they have sufficient rights to any resources you attempt
to use (otherwise, you will see 401 authentication errors).

You may also opt to take advantage of Authentication Grants to generate private application user key/secret in lieu of
username/password credentials.


## Using AMD

The driver also supports AMD.  If you're using a module loader like RequireJS, you can load the <code>gitana</code>
module and utilize it within your code.  Kind of like this:

```bash
define(["gitana"], function(Gitana) {

    Gitana.connect({
        "clientKey": "<clientKey>",
        "clientSecret": "<clientSecret>"
        "username": "<username>",
        "password": "<password>"
    }, function(err) {

        // this = platform

    });

});
```


## In Node JS

This driver is available via the <a href="https://npmjs.org/package/gitana">NPM Registry as 'gitana'</a>.

Using it in Node JS is pretty easy.  You can do something like the following:

```bash
var Gitana = require("gitana");

Gitana.connect({
    "clientKey": "<clientKey>",
    "clientSecret": "<clientSecret>"
    "username": "<username>",
    "password": "<password>"
});
```

## Driver API and Chaining

This driver makes it really simple to work with Cloud CMS data stores and objects as though they were local objects
right within your JS application.  The driver lets you get at all of the runtime and authoring capabilities of the
system.

In addition, this driver features asynchronous method chaining.  This lets you chain together commands that go over
the wire and avoid a lot of the headache of manually managing callbacks.  As a result, your code is smaller, there
is less to manage and it's easier to read.

Here is an example:

```bash
platform.createRepository().readBranch("master").createNode({"title": "Hello World"});
```

## Documentation

We've published our documentation for the JavaScript driver as well as other drivers to our
<a href="https://www.cloudcms.com/documentation.html">Documentation Site</a>.

In addition, we've published <a href="http://code.cloudcms.com/gitana-javascript-driver/latest/jsdoc/index.html">
JavaScript-level API documentation</a>.


## Build

To build locally, you must first sync the code to your local GitHub repository and also install Node.js.
Then, run the following:

```bash
npm install
```

This will install the latest versions of Grunt and all Grunt and Node.js dependencies for build and test.
Then, to build, run the following:

```bash
ant clean package
```

This will produce the latest <code>gitana.js</code> and <code>gitana.min.js</code> files in your <code>dist</code>
directory.

A Grunt file is provided with a number of useful tasks.  While Grunt is utilized, it does not provide the primary
build mechanism.  This project uses Ant and makes calls out to Grunt when needed.

One useful option is to run JSHint over any customizations to the code base.

```bash
grunt jshint
```

Wherever possible, please try to follow the code conventions utilized by the project.  For the most part, these
include spacing and line breaks that are generous so as to improve code readability.


## Testing

After you've performed a build, you can test it by doing the following:

```bash
grunt web
```

This starts up a local web server.  You can use this to run the tests locally by opening up a browser and going to:

```bash
http://localhost:8000/tests
```

You can also run the tests headlessly using PhantomJS.  To do so, run the following commands:

```bash
npm install phantomjs -g
grunt test
```

This will launch PhantomJS and run the QUnit tests without the need for a browser.  This is good for functional
testing (but is not a replacement for browser variation testing).


## Cloud CMS

You can learn more about Cloud CMS by visiting our web site at
<a href="http://www.cloudcms.com">http://www.cloudcms.com</a>.


## Maintainers
* Michael Uzquiano     uzi@cloudcms.com

