var server = require("cloudcms-server/server");

server.report(function(callback) {

    console.log("Web Server: http://localhost:" + process.env.PORT);
    console.log("");

    callback();
});

server.routes(function(app, callback) {
    
    app.get("/registration.html", function(req, res) {
        
        var model = {};

        if (req.session.registration_user_object) {
            model.user = req.session.registration_user_object;
            
            var errors = req.flash("errors");
            if (errors) {
                model.errors = errors;
            }
            
            model.hasErrors = (model.errors.length > 0);
        }
        
        res.render("registration.html", model);
    });
    
    app.get("/user/delete", function(req, res, next) {
        var userId = req.query["id"];
        /*
        req.gitana.datastore("principals").readPrincipal(userId).del().then(function() {
            res.redirect("/");
        });
        */
        console.log("USER ID: " + userId);
        next();
    });
  
    callback(); 
});

/**
 * Start the Server
 */
server.start({
    "setup": "single",
    "viewEngine": "dust",    
    "welcome": {
        "enabled": true,
        "file": "index.html"
    },
    "session": {
        "enabled": true,
        "type": "memory"
    },
    "registration": {
        "enabled": true,
        "options": {
            "passwords": false,
            "email": false,
            "usename": false
        }
    },    
    "auth": {
        "enabled": true,
        "providers": {
            "facebook1": {
                "type": "facebook",
                "config": {
                    "appId": process.env.SAMPLE_FACEBOOK_APP_ID,
                    "appSecret": process.env.SAMPLE_FACEBOOK_APP_SECRET,
                    "successRedirect": "/callback.html",
                    "failureRedirect": "/index.html",
                    "passTicket": true,
                    "passTokens": true,
                    "registrationRedirect": "/registration.html"              
                }
            },
            "twitter1": {
                "type": "twitter",
                "config": {
                    "consumerKey": process.env.SAMPLE_TWITTER_CONSUMER_KEY,
                    "consumerSecret": process.env.SAMPLE_TWITTER_CONSUMER_SECRET,
                    "successRedirect": "/callback.html",
                    "failureRedirect": "/index.html",
                    "passTicket": true,
                    "passTokens": true,
                    "registrationRedirect": "/registration.html"
                }
            },
            "linkedin1": {
                "type": "linkedin",
                "config": {
                    "apiKey": process.env.SAMPLE_LINKEDIN_API_KEY,
                    "apiSecret": process.env.SAMPLE_LINKEDIN_API_SECRET,
                    "successRedirect": "/callback.html",
                    "failureRedirect": "/index.html",
                    "passTicket": true,
                    "passTokens": true,
                    "registrationRedirect": "/registration.html"
                }
            }
        }
    }
});
