# Quickstart - AWS

This kit demonstrates how you might configure Cloud CMS to use:

- AWS DocumentDB Service (MongoDB 3.6 compatible)
- AWS Elastic Search Service

These services can be used in place of running your own MongoDB or Elastic Search containers.


## AWS DocumentDB Service

Edit the `api/classes/gitana/docker.properties` file and modify the following:

1) Supply the endpoint URL of your AWS DocumentDB cluster
2) Adjust your authentication settings

You may also optionally wish to use TLS/SSL.  If so, modify the driver's SSL settings.
The Dockerfile is pre-configured to add the `rds-combined-ca-bundle.pem` certificate to the TrustStore.

See https://docs.aws.amazon.com/documentdb/latest/developerguide/security.encryption.ssl.html for more information.
See https://www.cloudcms.com/documentation/docker/configuration/api-server.html#configuring-ssl-for-mongodb for Cloud CMS documentation on how to configure the properties file for SSL with MongoDB.

NOTE! You must launch the Cloud CMS API container inside of the same AWS VPC as DocumentDB itself.  If you wish to run
Cloud CMS in a separate environment while connecting to DocumentDB, you will need to set up a SSH tunnel.

https://docs.aws.amazon.com/documentdb/latest/developerguide/connect-from-outside-a-vpc.html

When using AWS DocumentDB, we recommend running Cloud CMS within an Amazon VPC.



## AWS Elastic Search Service

Edit the `api/classes/gitana/docker.properties` file and modify the following:

1) Supply the endpoint URL of your AWS Elastic Search cluster
2) Adjust your authentication settings
