# Authentication Examples

These examples provide a basis for learning about how authentication and SSO work within Cloud CMS.  
Each folder provides its own README with more information for launching the application server.

# Start up Cloud CMS

    cd cloudcms
    docker-compose up -d
    
# Start up Keycloak

    cd keycloak
    sh run.sh
    
## Set up Keycloak

    http://localhost:9090
    
Go to the admin console
Login as "admin/admin"

1.  Create a user called "test" with any password you like.  Set some attributes on the user.

2.  Create a new client called "test"
    - set Client Protocol to "openid-connect"
    - set Access Type to "confidential"
    - set Valid Redirect URIs to "*"
    - set Web Origins to "*"
    
    Click on the Installation tab and select "Keycloak OIDC JSON".
    Copy the value for "secret".  You will need it for the next section.
    
# Set up the Application Server

Log into Cloud CMS and get your gitana.json file.  Put it into the ./app directory.
Make sure that the "baseURL" for your gitana.json is:

    "baseURL": "http://localhost:8080"
    
Edit the app.js file.  Copy in the clientID (the username "test") and the client "secret" from the previous section.    

# Start up the Application Server

    cd app
    npm install
    node app
    
# Visit the Web Site

    http://localhost:3000